<?php


namespace onespace\tools\enum\oneaccess;

use onespace\tools\enum\base\UnbackedHelper;

enum AccessEventCode {

    use UnbackedHelper;

    case ACCESS_ALLOWED;
    case ACCESS_CONFIRMED;
    case ACCESS_UNCONFIRMED;
    case ACCESS_METHOD_DENIED_UNKNOWN;
    case ACCESS_METHOD_DENIED_ZERO_UID_EVENT;
    case ACCESS_METHOD_DENIED_DAYS_OF_WEEK;
    case ACCESS_METHOD_DENIED_NO_RIGHTS;
    case ACCESS_METHOD_DENIED_USER_NOT_FOUND;
    case ACCESS_METHOD_DENIED_GATEWAY_DISABLED;
    case ACCESS_METHOD_DENIED_READER_UNKNOWN;
    case ACCESS_RIGHTS_DENIED_READER;
    case ACCESS_RIGHTS_DENIED_DAYS_OF_WEEK;
    case ACCESS_RIGHTS_DENIED_TIME_OF_DAY;
    case ACCESS_USER_DENIED_NO_RIGHTS;
    case ACCESS_USER_DENIED_NO_ENTRIES_LEFT;
    case ACCESS_USER_DENIED_NO_EXITS_LEFT;
    case ACCESS_USER_DENIED_FUTURE_DATED;
    case ACCESS_USER_DENIED_EXPIRED;

    private function config(string $key): string|int {
        $config = match ($this) {
            self::ACCESS_ALLOWED => [
                'id' => 1,
                'name' => 'Access Allowed',
            ],
            self::ACCESS_CONFIRMED => [
                'id' => 2,
                'name' => 'Access Confirmed',
            ],
            self::ACCESS_UNCONFIRMED => [
                'id' => 3,
                'name' => 'Access Unconfirmed',
            ],
            self::ACCESS_METHOD_DENIED_UNKNOWN => [
                'id' => 4,
                'name' => 'Access Method Denied Unknown',
            ],
            self::ACCESS_METHOD_DENIED_ZERO_UID_EVENT => [
                'id' => 5,
                'name' => 'Access Method Denied Zero UID Event',
            ],
            self::ACCESS_METHOD_DENIED_DAYS_OF_WEEK => [
                'id' => 6,
                'name' => 'Access Method Denied Days Of Week',
            ],
            self::ACCESS_METHOD_DENIED_NO_RIGHTS => [
                'id' => 7,
                'name' => 'Access Method Denied No Rights',
            ],
            self::ACCESS_METHOD_DENIED_USER_NOT_FOUND => [
                'id' => 8,
                'name' => 'Access Method Denied User Not Found',
            ],
            self::ACCESS_METHOD_DENIED_GATEWAY_DISABLED => [
                'id' => 9,
                'name' => 'Access Method Denied Gateway Disabled',
            ],
            self::ACCESS_METHOD_DENIED_READER_UNKNOWN => [
                'id' => 10,
                'name' => 'Access Method Denied Reader Unknown',
            ],
            self::ACCESS_RIGHTS_DENIED_READER => [
                'id' => 11,
                'name' => 'Access Rights Denied Reader',
            ],
            self::ACCESS_RIGHTS_DENIED_DAYS_OF_WEEK => [
                'id' => 12,
                'name' => 'Access Rights Denied Days Of Week',
            ],
            self::ACCESS_RIGHTS_DENIED_TIME_OF_DAY => [
                'id' => 13,
                'name' => 'Access Rights Denied Time Of Day',
            ],
            self::ACCESS_USER_DENIED_NO_RIGHTS => [
                'id' => 14,
                'name' => 'Access User Denied No Rights',
            ],
            self::ACCESS_USER_DENIED_NO_ENTRIES_LEFT => [
                'id' => 15,
                'name' => 'Access User Denied No Entries Left',
            ],
            self::ACCESS_USER_DENIED_NO_EXITS_LEFT => [
                'id' => 16,
                'name' => 'Access User Denied No Exits Left',
            ],
            self::ACCESS_USER_DENIED_FUTURE_DATED => [
                'id' => 17,
                'name' => 'Access User Denied Future Dated',
            ],
            self::ACCESS_USER_DENIED_EXPIRED => [
                'id' => 18,
                'name' => 'Access User Denied Expired',
            ],
        };
        return $config[$key];
    }


    public function id(): int {
        return $this->config('id');
    }


    public function name(): string {
        return $this->config('name');
    }
}
