<?php

namespace onespace\tools\enum\oneaccess;

use onespace\tools\enum\base\LabelEnumTrait;
use onespace\tools\enum\base\ListableEnumTrait;

enum VisitStatus: int {

    use LabelEnumTrait;
    use ListableEnumTrait;

    case ACTIVE = 1;
    case UPCOMING = 2;
    case CANCELLED = 3;
    case REDEEMED = 4;
    case EXPIRED = 5;
    case AWAITING_VISITOR_RESPONSE = 6;
    case AWAITING_USER_APPROVAL = 7;
    case ROLLOVER = 8;

    public static function labels(): array {
        return [
            self::ACTIVE->value => 'Active',
            self::UPCOMING->value => 'Upcoming',
            self::CANCELLED->value => 'Cancelled',
            self::REDEEMED->value => 'Redeemed',
            self::EXPIRED->value => 'Expired',
            self::AWAITING_VISITOR_RESPONSE->value => 'Awaiting Visitor Response',
            self::AWAITING_USER_APPROVAL->value => 'Awaiting User Approval',
            self::ROLLOVER->value => 'Rollover'
        ];
    }


    public static function validStatus($status): bool {
        if (is_int($status) || is_int(intval($status))) {
            if ($status >= 0 && $status < count(VisitStatus::list())) {
                return true;
            }
        }
        return false;
    }


    public static function randomTestValue(): int {
        $val = random_int(1, 8);
        return self::from($val)->value;
    }
}
