<?php


namespace onespace\tools\enum\oneaccess;

use onespace\tools\enum\base\UnbackedHelper;

enum AccessEventCode {

    use UnbackedHelper;

    case ACCESS_ALLOWED;
    case ACCESS_DENIED_DEVICE_UNKNOWN;
    case ACCESS_DENIED_DEVICE_ZERO;
    case ACCESS_DENIED_DEVICE_SPECIAL_DAYS_OF_WEEK;
    case ACCESS_DENIED_DEVICE_NO_GROUP;
    case ACCESS_DENIED_GROUP_GATEWAY;
    case ACCESS_DENIED_GROUP_DAYS_OF_WEEK;
    case ACCESS_DENIED_GROUP_TIME_OF_DAY;
    case ACCESS_USER_ENTRY_REDEEMED;
    case ACCESS_USER_EXIT_REDEEMED;
    case ACCESS_DENIED_USER_NO_ENTRIES_LEFT;
    case ACCESS_DENIED_USER_NO_EXITS_LEFT;
    case ACCESS_DENIED_USER_FUTURE_DATED;
    case ACCESS_DENIED_USER_EXPIRED;
    case ACCESS_DENIED_GATEWAY_DISABLED;
    case ACCESS_DENIED_READER_UNKNOWN;


    private function config(string $key): string|int {
        $config = match ($this) {
            self::ACCESS_ALLOWED => [
                'id' => 1,
                'name' => 'Access Allowed',
            ],
            self::ACCESS_DENIED_DEVICE_UNKNOWN => [
                'id' => 2,
                'name' => 'Access Denied User No Entries Left',
            ],
            self::ACCESS_DENIED_DEVICE_ZERO => [
                'id' => 3,
                'name' => 'Access Denied User No Exits Left',
            ],
            self::ACCESS_DENIED_DEVICE_SPECIAL_DAYS_OF_WEEK => [
                'id' => 4,
                'name' => 'Access Denied User Future Dated',
            ],
            self::ACCESS_DENIED_DEVICE_NO_GROUP => [
                'id' => 5,
                'name' => 'Access Denied User Expired',
            ],
            self::ACCESS_DENIED_GROUP_GATEWAY => [
                'id' => 6,
                'name' => 'Access User Entry Redeemed',
            ],
            self::ACCESS_DENIED_GROUP_DAYS_OF_WEEK => [
                'id' => 7,
                'name' => 'Access User Exit Redeemed',
            ],
            self::ACCESS_DENIED_GROUP_TIME_OF_DAY => [
                'id' => 8,
                'name' => 'Access Denied Device Unknown',
            ],
            self::ACCESS_USER_ENTRY_REDEEMED => [
                'id' => 9,
                'name' => 'Access Denied Gateway Disabled',
            ],
            self::ACCESS_USER_EXIT_REDEEMED => [
                'id' => 10,
                'name' => 'Access Denied Device Special Days Of Week',
            ],
            self::ACCESS_DENIED_USER_NO_ENTRIES_LEFT => [
                'id' => 11,
                'name' => 'Access Denied Group Gateway',
            ],
            self::ACCESS_DENIED_USER_NO_EXITS_LEFT => [
                'id' => 12,
                'name' => 'Access Denied Group Days Of Week',
            ],
            self::ACCESS_DENIED_USER_FUTURE_DATED => [
                'id' => 13,
                'name' => 'Access Denied Group Time Of Day',
            ],
            self::ACCESS_DENIED_USER_EXPIRED => [
                'id' => 14,
                'name' => 'Access Denied Device Zero',
            ],
            self::ACCESS_DENIED_GATEWAY_DISABLED => [
                'id' => 15,
                'name' => 'Access Denied Device No Group',
            ],
            self::ACCESS_DENIED_READER_UNKNOWN => [
                'id' => 16,
                'name' => 'Access Denied Reader Unknown',
            ],
        };
        return $config[$key];
    }


    public function id(): int {
        return $this->config('id');
    }


    public function name(): string {
        return $this->config('name');
    }
}
