<?php

namespace onespace\tools\enum\oneaccess;

use onespace\tools\enum\base\LabelEnumTrait;
use onespace\tools\enum\base\ListableEnumTrait;

enum VisitorTypes: int {

    use LabelEnumTrait;
    use ListableEnumTrait;

    case DEFAULT = 1;
    case FRIEND = 2;
    case FAMILY = 3;
    case BUSINESS = 4;
    case CONTRACTOR = 5;
    case DELIVERY = 6;
    case TAXI = 7;
    case E_HAIL = 8;
    case EMERGENCY = 9;
    case PATRONS = 10;

    public static function labels(): array {
        return [
            self::DEFAULT->value => "Default",
            self::FRIEND->value => "Friend",
            self::FAMILY->value => "Family",
            self::BUSINESS->value => "Business",
            self::CONTRACTOR->value => "Contractor",
            self::DELIVERY->value => "Delivery",
            self::TAXI->value => "Taxi",
            self::E_HAIL->value => "E-Hail",
            self::EMERGENCY->value => "Emergency",
            self::PATRONS->value => "Patrons",
        ];
    }


    public static function randomTestValue(): int {
        $val = random_int(1, 10);
        return self::from($val)->value;
    }
}
