<?php

namespace onespace\tools\enum\oneaccess;

use onespace\tools\enum\base\UnbackedHelper;

enum ReaderType {

    use UnbackedHelper;

    case BLUETOOTH;
    case OSDP;

    private function config(string $key): array {
        $config = match ($this) {
            self::BLUETOOTH => [
                'id' => 1,
                'name' => 'Bluetooth',
            ],
            self::OSDP => [
                'id' => 2,
                'name' => 'OSDP'
            ],
        };
        return $config[$key];
    }


    public function id(): int {
        return $this->config('id');
    }


    public function name(): string {
        return $this->config('name');
    }

}
