<?php

namespace onespace\tools\enum\base;

use BackedEnum;
use UnitEnum;
use yii\helpers\ArrayHelper;

trait LabelEnumTrait {

    abstract public static function labels(): array;

    public static function getLabel(int|string|self $key): string {
        return ArrayHelper::getValue(self::labels(), $key, '');
    }

    public function label(): string {
        if ($this instanceof BackedEnum) {
            return self::getLabel($this->value);
        } else if ($this instanceof UnitEnum) {
            return self::getLabel($this->name);
        } else {
            return '';
        }
    }
}
