<?php

namespace onespace\tools\activeApi\models\socialmessenger;

use onespace\tools\activeApi\components\clients\SocialMessengerClient;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * @property string $id
 * @property string $name
 * @property string $description
 * @property bool $monitored
 * @property string $createdAt
 * @property string $provider
 */
class Group extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $name;
    public $description;
    public $monitored;
    public $createdAt;
    public $provider;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['id'], 'string', 'max' => 45],
            [['name'], 'string', 'max' => 255],
            [['description'], 'string', 'max' => 1024],
            [['provider'], 'string', 'max' => 125],
            [['created_at'], 'date'],
            [['monitored'], 'boolean'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function client(): SocialMessengerClient {
        return new SocialMessengerClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/group',
        ];
    }

    public static function findModelById(int $id): static {
        $model = self::findOne(['id' => $id]);
        if ($model === null) {
            throw new NotFoundHttpException('Group not found');
        }

        return $model;
    }

    public static function findForSite(string $siteGuid) {

    }
}
