<?php

namespace onespace\tools\activeApi\models\socialmessenger;

use onespace\tools\activeApi\components\clients\SocialMessengerClient;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * @property string $cellNumber
 * @property string $name
 * @property string $provider
 *
 * @property array $groups
 * @property array $features
 */
class Bot extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $cellNumber;
    public $name;
    public $provider;
    public $groups;
    public $features;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['cellNumber'], 'string', 'max' => 45],
            [['name'], 'string', 'max' => 125],
            [['provider'], 'string', 'max' => 125],
            [['groups', 'features'], 'safe'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function client(): SocialMessengerClient {
        return new SocialMessengerClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'cellNumber';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/bot',
        ];
    }

    public static function findModelById(int $id): static {
        $model = self::findOne(['cellNumber' => $id]);
        if ($model === null) {
            throw new NotFoundHttpException('Bot not found');
        }

        return $model;
    }
}
