<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property integer $reader_id
 * @property integer $access_point_id
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class ReaderAccessPoint extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $reader_id;
    public $access_point_id;

    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['reader_id', 'access_point_id'], 'required'],
            [['id', 'reader_id', 'access_point_id'], 'integer'],
        ]);
    }

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/reader-access-point',
        ];
    }
}
