<?php

namespace onespace\tools\activeApi\helpers;

use Yii;

/**
 * Assists with detecting the context of the runtime of the current application
 * 
 * @author Gareth Palmer <gareth@one-space.co.za>
 */
trait ContextHelper {
    /**
     * Detects if the context of the application running is the CLI
     */    
    public function isCli(): bool {
        return Yii::$app instanceof \yii\console\Application;
    }

    /**
     * Detects if the context of the application running is the WEB
     */
    public function isWeb(): bool {
        return Yii::$app instanceof \yii\web\Application;
    }
}