<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need * a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $name
 * @property string $icon
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class AccessMethodType extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $name;
    public $icon;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return ArrayHelper::merge(parent::rules(), [
            [['name'], 'string', 'max' => 255],
            [['icon'], 'string', 'max' => 100],
            [['name', 'icon'], 'required'],
        ]);
    }

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/access-method-type',
            'v2' => 'v2/access-method-type',
        ];
    }

    public static function list(): array {
        return ArrayHelper::map(
            self::find()->all() ?? [],
            'id',
            'name'
        );
    }

    public static function findById(?int $id): ?self {
        if ($id === null) {
            return null;
        }
        return self::findOne(['id' => $id]);
    }

    public static function findByName(?string $name): ?self {
        if ($name === null) {
            return null;
        }
        return self::findOne(['name' => $name]);
    }
}
