<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need * a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $reader_type
 * @property string $make
 * @property string $model
 * @property integer $interface_type
 * @property integer $disable_interface_choice
 * @property string $available_interfaces
 * @property integer $interface_index
 * @property integer $disable_interface_index
 * @property string $device_description
 * @property string $device_image
 * @property integer $requires_logical_address
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class ReaderTemplate extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $reader_type;
    public $make;
    public $model;
    public $interface_type;
    public $disable_interface_choice;
    public $available_interfaces;
    public $interface_index;
    public $disable_interface_index;
    public $device_description;
    public $device_image;
    public $requires_logical_address;

    /**
     * {@inheritdoc}
     */
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/reader-template',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return ArrayHelper::merge(parent::rules(), [
            [['reader_type', 'make', 'model', 'interface_type'], 'required'],
            [['interface_type', 'disable_interface_choice', 'interface_index', 'disable_interface_index', 'requires_logical_address'], 'integer'],
            [['device_description'], 'string'],
            [['reader_type', 'device_image'], 'string', 'max' => 255],
            [['make', 'model'], 'string', 'max' => 250],
        ]);
    }

    public function beforeValidate(): bool {
        if (!parent::beforeValidate()) {
            return false;
        }
        if (is_array($this->available_interfaces)) {
            $this->available_interfaces = json_encode($this->available_interfaces);
        }
        return true;
    }

    public function beforeSave(bool $insert): bool {
        if (parent::beforeSave($insert)) {
            if (is_array($this->available_interfaces)) {
                $this->available_interfaces = json_encode($this->available_interfaces);
            }
            return true;
        }
        return false;
    }

    public function afterFind(): void {
        parent::afterFind();
        if (is_string($this->available_interfaces)) {
            $this->available_interfaces = json_decode($this->available_interfaces, true);
        }
    }

    /**
     * @throws NotFoundHttpException
     */
    public static function findById(int $id): static {
        $model = self::findOne(['id' => $id]);
        if ($model === null) {
            throw new NotFoundHttpException("Reader Template not found");
        }
        return $model;
    }
}
