<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need * a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $guid
 * @property string $site_id
 * @property integer $access_gateway_id
 * @property integer $reader_id
 * @property string $gateway_timestamp
 * @property string $server_timestamp
 * @property integer $success_code
 * @property string $success_message
 * @property string $access_device_serial
 * @property integer $access_method_id
 * @property string $OSID
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class AccessEvent extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $site_id;
    public $access_gateway_id;
    public $reader_id;
    public $gateway_timestamp;
    public $server_timestamp;
    public $success_code;
    public $success_message;
    public $access_device_serial;
    public $access_method_id;
    public $OSID;

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/access-event',
            'v2' => 'v2/access-event',
        ];
    }
}
