<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need * a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property integer $access_right_id
 * @property integer $reader_id
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class AccessRightReader extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $access_right_id;
    public $reader_id;

    /**
     * {@inheritdoc}
     */
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return ['v1' => 'v1/access-right-reader'];
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return [
            [['access_right_id', 'reader_id'], 'required'],
            [['access_right_id', 'reader_id'], 'integer'],
        ];
    }
}
