<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need * a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property integer $gateway_id
 * @property integer $reader_id
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class AccessGatewayReader extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $gateway_id;
    public $reader_id;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return ArrayHelper::merge(parent::rules(), [
            [['gateway_id', 'reader_id'], 'integer'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/access-gateway-reader',
        ];
    }
}
