<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need * a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $guid
 * @property string $name
 * @property integer $logical_address
 * @property string $site_id
 * @property string $first_seen
 * @property string $last_seen
 * @property integer $online
 * @property integer $physical_perimeter
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class AccessGateway extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $name;
    public $logical_address;
    public $site_id;
    public $first_seen;
    public $last_seen;
    public $online;
    public $physical_perimeter;

    public const STATUS_ONLINE = true;
    public const STATUS_OFFLINE = false;

    public const PHYSICAL_PERIMETER_PRESENT = true;
    public const PHYSICAL_PERIMETER_NOT_PRESENT = false;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return ArrayHelper::merge(parent::rules(), [
            [['logical_address', 'online', 'physical_perimeter'], 'integer'],
            [['first_seen', 'last_seen'], 'safe'],
            [['guid', 'site_id'], 'string', 'max' => 36],
            [['name'], 'string', 'max' => 255],
            [['name', 'logical_address', 'site_id', 'physical_perimeter'], 'required'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return ['v1' => 'v1/access-gateway'];
    }

    public static function perimeterPresent(): array {
        return [
            self::PHYSICAL_PERIMETER_PRESENT => 'Present',
            self::PHYSICAL_PERIMETER_NOT_PRESENT => 'Not Present',
        ];
    }
}
