<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need * a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $owner_osid
 * @property string $scope
 * @property string $body_part
 * @property string $manufacturer
 * @property string $payload
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class UserBiometric extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v2' => 'v2/user-biometric',
        ];
    }

    public function getScopes(): array {
        return explode(", ", $this->scope);
    }
}
