<?php

namespace onespace\tools\activeApi\components\clients;

use onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient;
use Yii;

/**
 * The client to connect to the VMS4 Microservice
 * 
 * Extend from here to add functionality.
 * 
 * Add the following to `config/params.php`:
 * 
 * ```php
 * 'serviceUrls' => [
 *  ...
 *  'vms4' => getenv('SERVICE_URL_VMS4') ?: 'https://dev.visit.1s.co.za/',
 *  ...
 * ],
 * ```
 */

class VMSClient extends BaseOneSpaceClient {

    public function serverUrl(): string {
        return Yii::$app->params['serviceUrls']['vms4'];
    }
}
