<?php

namespace onespace\tools\activeApi\components\clients;

use onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient;
use Yii;

/**
 * The client to connect to the Activity Microservice
 * 
 * Extend from here to add functionality.
 * 
 * Add the following to `config/params.php`:
 * 
 * ```php
 * 'serviceUrls' => [
 *  ...
 *  'ams' => getenv('SERVICE_URL_AMS') ?: 'https://dev.activity.1s.co.za/',
 *  ...
 * ],
 * ```
 */

class AMSClient extends BaseOneSpaceClient
{
    public function serverUrl(): string
    {
        return Yii::$app->params['serviceUrls']['ams'];
    }
}