<?php

namespace onespace\tools\activeApi\models\vms;

use onespace\tools\activeApi\components\clients\VMSClient;
use yii\web\NotFoundHttpException;

/**
 * @property integer $id
 * @property string $visitor
 * @property string $access_user
 * @property string $osid
 * @property string $name
 * @property string $surname
 * @property string $phone
 * @property string $company
 * @property string $vehicle_registration
 * @property integer $visitor_type_id
 * @property integer $favourite_visitor_id
 */
class Visitors extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $visitor;
    public $access_user;
    public $osid;
    public $name;
    public $surname;
    public $phone;
    public $company;
    public $vehicle_registration;
    public $visitor_type_id;
    public $favourite_visitor_id;

    /**
     * {@inheritdoc}
     */
    public function client(): VMSClient {
        return new VMSClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'api/v2/visitor', // v2 is deliberate
        ];
    }

    public static function findById(int $id): static {
        $model = self::findOne(['id' => $id]);
        if ($model === null) {
            throw new NotFoundHttpException("Visitor not found");
        }

        return $model;
    }

    public static function findByGuid(string $guid): static {
        $model = self::findOne(['visitor' => $guid]);
        if ($model === null) {
            throw new NotFoundHttpException("Visitor not found");
        }

        return $model;
    }
}
