<?php

namespace onespace\tools\activeApi\models\vms;

use onespace\tools\activeApi\components\clients\VMSClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $site
 * @property integer $pin_settings
 * @property string $default_share_message
 * @property string $sms_share_message
 * @property integer $max_visit_days
 * @property integer $max_visit_uses
 * @property integer $min_pin
 * @property integer $max_pin
 * @property integer $default_fields_added
 * @property string $default_fields_last_added
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class Site extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $site;
    public $pin_settings;
    public $default_share_message;
    public $sms_share_message;
    public $max_visit_days;
    public $max_visit_uses;
    public $min_pin;
    public $max_pin;
    public $default_fields_added;
    public $default_fields_last_added;

    /**
     * {@inheritdoc}
     */
    public function client(): VMSClient {
        return new VMSClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'api/v2/site',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['site'], 'required'],
            [['pin_settings', 'max_visit_days', 'max_visit_uses', 'min_pin', 'max_pin', 'default_fields_added'], 'integer'],
            [['default_fields_last_added'], 'safe'],
            [['site'], 'string', 'max' => 40],
            [['default_share_message', 'sms_share_message'], 'string', 'max' => 255],
            [['site'], 'unique'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'id' => 'ID',
            'site' => 'Site',
            'pin_settings' => 'Pin Settings',
            'default_share_message' => 'Default Share Message',
            'sms_share_message' => 'Sms Share Message',
            'max_visit_days' => 'Max Visit Days',
            'max_visit_uses' => 'Max Visit Uses',
            'min_pin' => 'Min Pin',
            'max_pin' => 'Max Pin',
            'default_fields_added' => 'Default Fields Added',
            'default_fields_last_added' => 'Default Fields Last Added',
        ]);
    }
}
