<?php

namespace onespace\tools\activeApi\models\socialmessenger;

use onespace\tools\activeApi\components\clients\SocialMessengerClient;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * @property string $id
 * @property string $providerMessageId
 * @property string $type
 * @property string $text
 * @property string $state
 * @property string $sentAt
 * @property string $deletedAt
 *
 * @property array $group
 * @property array $sendingMember
 */
class Message extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $providerMessageId;
    public $type;
    public $text;
    public $state;
    public $sentAt;
    public $deletedAt;
    public $group;
    public $sendingMember;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['id'], 'string', 'max' => 45],
            [['providerMessageId'], 'string', 'max' => 50],
            [['type'], 'string', 'max' => 125],
            [['text', 'state'], 'string'],
            [['sentAt', 'deletedAt'], 'date'],
            [['group', 'sendingMember'], 'safe'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function client(): SocialMessengerClient {
        return new SocialMessengerClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/message',
        ];
    }

    public static function findModelById(int $id): static {
        $model = self::findOne(['id' => $id]);
        if ($model === null) {
            throw new NotFoundHttpException('Message not found');
        }

        return $model;
    }

    public static function findForSite(string $siteGuid) {

    }
}
