<?php

namespace onespace\tools\activeApi\components\clients;

use onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient;
use Yii;
use yii\web\NotFoundHttpException;

class SimDetailsClient extends BaseOneSpaceClient {
    public function serverUrl(): string {
        return Yii::$app->params['serviceUrls']['simDetailsApi'];
    }

    public function fetchSimDetails(): array {
        $url = $this->serverUrl() . 'fetch-all-sim-data';
        Yii::info($url, __METHOD__);

        $request = $this->getClient()->get($url);
        $this->setLastRequest($request);
        $response = $request->send();
        if (!$response->isOk) {
            throw new NotFoundHttpException("Cannot fetch sim details");
        }
        return $response->data['data'];
    }
}
