<?php

namespace onespace\tools\activeApi\components\clients;

use onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient;
use Yii;

/**
 * The client to connect to the OneCompany Microservice
 *
 * Extend from here to add functionality.
 *
 * Add the following to `config/params.php`:
 *
 * ```php
 * 'serviceUrls' => [
 *  ...
 *  'oneCompany' => getenv('SERVICE_URL_ONECOMPANY') ?: 'https://dev.1company.1s.co.za/',
 *  ...
 * ],
 * ```
 */

class OneCompanyClient extends BaseOneSpaceClient {
    public function serverUrl(): string {
        return Yii::$app->params['serviceUrls']['oneCompany'];
    }
}
