<?php

namespace onespace\tools\activeApi\models\socialmessenger;

use onespace\tools\activeApi\components\clients\SocialMessengerClient;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * @property string $cellNumber
 * @property string $name
 * @property string $createdAt
 *
 * @property array $providerIds
 * @property array $groups
 *
 */
class Member extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $cellNumber;
    public $name;
    public $createdAt;
    public $providerIds;
    public $groups;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['cellNumber'], 'string', 'max' => 45],
            [['name'], 'string', 'max' => 255],
            [['created_at'], 'date'],
            [['providerIds', 'groups'], 'safe'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function client(): SocialMessengerClient {
        return new SocialMessengerClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'cellNumber';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/member',
        ];
    }

    public static function findModelById(int $id): static {
        $model = self::findOne(['cellNumber' => $id]);
        if ($model === null) {
            throw new NotFoundHttpException('Member not found');
        }

        return $model;
    }

    public static function findForSite(string $siteGuid) {

    }
}
