<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $guid
 * @property string $name
 * @property string $bluetooth_display_name
 * @property integer $logical_address
 * @property string $site_id
 * @property string $first_seen
 * @property string $last_seen
 * @property integer $online
 * @property integer $physical_perimeter
 * @property string $timezone
 * @property integer $relay_duration
 * @property string $asset_location
 * @property integer $status
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class AccessGateway extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $name;
    public $bluetooth_display_name;
    public $logical_address;
    public $site_id;
    public $first_seen;
    public $last_seen;
    public $online;
    /** @deprecated */
    public $physical_perimeter;
    public $timezone;
    public $relay_duration;
    public $asset_location;
    public $status;

    public const STATUS_ONLINE = 1;
    public const STATUS_OFFLINE = 0;


    /** @deprecated */
    public const PHYSICAL_PERIMETER_PRESENT = true;
    /** @deprecated */
    public const PHYSICAL_PERIMETER_NOT_PRESENT = false;

    /**
     * {@inheritdoc}
     */
    public function rules() {
        return ArrayHelper::merge(parent::rules(), [
            [['name', 'bluetooth_display_name', 'logical_address', 'first_seen', 'last_seen', 'physical_perimeter', 'asset_location'], 'default', 'value' => null],
            [['online'], 'default', 'value' => 0],
            [['timezone'], 'default', 'value' => '+2:00'],
            [['relay_duration'], 'default', 'value' => 4],
            [['status'], 'default', 'value' => 1],
            [['id', 'logical_address', 'online', 'physical_perimeter', 'relay_duration', 'status'], 'integer'],
            [['first_seen', 'last_seen'], 'safe'],
            [['guid', 'site_id', 'asset_location'], 'string', 'max' => 36],
            [['name', 'bluetooth_display_name'], 'string', 'max' => 255],
            [['timezone'], 'string', 'max' => 10],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return ['v1' => 'v1/access-gateway'];
    }

    public static function perimeterPresent(): array {
        return [
            self::PHYSICAL_PERIMETER_PRESENT => 'Present',
            self::PHYSICAL_PERIMETER_NOT_PRESENT => 'Not Present',
        ];
    }
}
