<?php

namespace onespace\tools\activeApi\models\people;

use onespace\tools\activeApi\components\clients\PeopleClient;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * @property integer $id
 * @property string $guid
 * @property string $name
 * @property integer $type
 * @property integer $approval_type
 */
class Site extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $name;
    public $type;
    public $approval_type;

    public const ACCESS_CONTROL_NOT_SET = 0;
    public const ACCESS_CONTROL_BESECURE = 1;
    public const ACCESS_CONTROL_ONEACCESS = 2;

    /**
     * {@inheritdoc}
     */
    public function client(): PeopleClient {
        return new PeopleClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'api/v1/site',
        ];
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['type', 'approval_type'], 'default', 'value' => 0],
            [['guid', 'name'], 'required'],
            [['type', 'approval_type'], 'integer'],
            [['guid'], 'string', 'max' => 36],
            [['name'], 'string', 'max' => 250],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function attributeLabels() {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'id' => 'ID',
            'guid' => 'Guid',
            'name' => 'Name',
            'type' => 'Type',
            'approval_type' => 'Approval Type',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function attributeHints() {
        return ArrayHelper::merge(parent::attributeHints(), [
            'guid' => 'The Site GUID for the estate',
            'name' => 'The name of the site.',
            'approval_type' => 'Dictates what to do with external data changes. See Approval Enum',
        ]);
    }

    /**
     * @throws  NotFoundHttpException
     */
    public static function findById(int $id): Site {
        $model = self::findOne(['id' => $id]);

        if ($model === null) {
            throw new NotFoundHttpException("Site not found");
        }

        return $model;
    }

    /**
     * @throws  NotFoundHttpException
     */
    public static function findByGuid(string $guid): Site {
        $model = self::findOne(['guid' => $guid]);

        if ($model === null) {
            throw new NotFoundHttpException("Site not found");
        }

        return $model;
    }
}
