<?php

namespace onespace\tools\activeApi\components\clients\teams\actions;

use Exception;

/**
 * Generate a button that opens a URL.
 *
 * @author Gareth Palmer <gareth@one-space.co.za>
 */
final class TeamsActionOpenUrl extends TeamsActions {
    public function __construct(
        public string $title,
        public string $url,
    ) {
    }

    #[\Override]
    public function build(): array {
        if (!isset($this->title)) {
            throw new Exception('Title not set');
        }
        if (!isset($this->url)) {
            throw new Exception('Url not set');
        }
        return [
            "type" => ActionOption::OPEN_URL->value,
            "title" => $this->title,
            "url" => $this->url,
        ];
    }
}
