<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property integer $access_method_id
 * @property integer $access_right_id
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class AccessMethodAccessRight extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $access_method_id;
    public $access_right_id;

    public $allGroups; // TO CHANGE
    public $allIds;

    public function rules() {
        return ArrayHelper::merge(
            parent::rules(),
            [
                [['id', 'access_method_id', 'access_right_id'], 'integer'],
                [['allGroups'], 'safe'],
            ]
        );
    }

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/access-method-access-right',
            'v2' => 'v2/access-method',
        ];
    }
}
