<?php

namespace onespace\tools\activeApi\models\enum;

enum NotificationAction: string {
    case NOTIFICATION_ACTION_SHOW_MESSAGES = 'showmessages';
    case NOTIFICATION_ACTION_ENROL_ACCEPTED = 'showaccepted';
    case NOTIFICATION_ACTION_ENROL_REJECTED = 'showrejected';
    case NOTIFICATION_ACTION_ENROLMENTS = 'showenrolments';
    case NOTIFICATION_ACTION_ACCESS_DEVICES = 'showdevices';

    public static function labels(): array {
        return [
            self::NOTIFICATION_ACTION_SHOW_MESSAGES->value => 'Show Messages',
            self::NOTIFICATION_ACTION_ENROL_ACCEPTED->value => 'Show Accepted',
            self::NOTIFICATION_ACTION_ENROL_REJECTED->value => 'Show Rejected',
            self::NOTIFICATION_ACTION_ENROLMENTS->value => 'Show Enrolments',
            self::NOTIFICATION_ACTION_ACCESS_DEVICES->value => 'Show Devices',
        ];
    }
}
