<?php

namespace onespace\tools\activeApi\models\enum;

enum NotificationMethod: string {
    case METHOD_PUSH_NOTIFICATION = 'push';
    case METHOD_EMAIL = 'email';
    case METHOD_BLANK_EMAIL = 'email_blank';
    case METHOD_SMS = 'sms';
    public const METHOD_BLANK_EMAIL_AND_PUSH = 'email_blank_and_push';

    public static function labels(): array {
        return [
            self::METHOD_PUSH_NOTIFICATION->value => 'Push',
            self::METHOD_EMAIL->value => 'Email',
            self::METHOD_BLANK_EMAIL->value => 'Blank Email',
            self::METHOD_SMS->value => 'SMS',
            self::METHOD_BLANK_EMAIL_AND_PUSH => 'Blank Email and Push',
        ];
    }
}
