<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $owner_osid
 * @property string $scope
 * @property string $body_part
 * @property string $manufacturer
 * @property string $payload
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class UserBiometric extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $owner_osid;
    public $scope;
    public $body_part;
    public $manufacturer;
    public $payload;

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v2' => 'v2/user-biometric',
        ];
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['scope', 'manufacturer', 'payload'], 'default', 'value' => null],
            [['owner_osid', 'body_part'], 'required'],
            [['scope', 'payload'], 'string'],
            [['owner_osid', 'manufacturer'], 'string', 'max' => 45],
            [['body_part'], 'string', 'max' => 10],
            [['id'], 'integer'],
        ]);
    }


    public function getScopes(): array {
        return explode(", ", $this->scope);
    }
}
