<?php

namespace onespace\tools\activeApi\models\people;

use onespace\tools\activeApi\components\clients\PeopleClient;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * @property integer $id
 * @property string $guid
 * @property string $name
 * @property integer $type
 */
class Site extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $name;
    public $type;

    /**
     * {@inheritdoc}
     */
    public function client(): PeopleClient {
        return new PeopleClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/site',
        ];
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['type'], 'default', 'value' => 0],
            [['guid', 'name'], 'required'],
            [['type'], 'integer'],
            [['guid'], 'string', 'max' => 36],
            [['name'], 'string', 'max' => 250],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function attributeLabels() {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'id' => 'ID',
            'guid' => 'Guid',
            'name' => 'Name',
            'type' => 'Type',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function attributeHints() {
        return ArrayHelper::merge(parent::attributeHints(), [
            'guid' => 'The Site GUID for the estate',
            'name' => 'The name of the site.',
        ]);
    }

    /**
     * @throws  NotFoundHttpException
     */
    public static function findById(int $id): Site {
        $model = self::findOne(['id' => $id]);

        if ($model === null) {
            throw new NotFoundHttpException("Site not found");
        }

        return $model;
    }

    /**
     * @throws  NotFoundHttpException
     */
    public static function findByGuid(string $guid): Site {
        $model = self::findOne(['guid' => $guid]);

        if ($model === null) {
            throw new NotFoundHttpException("Site not found");
        }

        return $model;
    }
}
