<?php

namespace onespace\tools\activeApi\models\vms;

use onespace\tools\activeApi\components\clients\VMSClient;
use yii\web\NotFoundHttpException;

/**
 * @property integer $id
 * @property string $visit
 * @property string $pin
 * @property string $access_method
 * @property string $site
 * @property string $visitor_access_right
 * @property string $property
 * @property string $generating_user
 * @property string $generating_device
 * @property string $comment
 * @property string $time_generated_at
 * @property string $time_updated_at
 * @property string $start_date
 * @property string $end_date
 * @property integer $uses_generated_for
 * @property integer $entries_redeemed
 * @property integer $exits_redeemed
 * @property integer $status
 * @property string $cancelling_user
 * @property string $cancellation_time
 * @property integer $visitor_id
 * @property integer $flag
 */
class Visits extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $visit;
    public $pin;
    public $access_method;
    public $site;
    public $visitor_access_right;
    public $property;
    public $generating_user;
    public $generating_device;
    public $comment;
    public $time_generated_at;
    public $time_updated_at;
    public $start_date;
    public $end_date;
    public $uses_generated_for;
    public $entries_redeemed;
    public $exits_redeemed;
    public $status;
    public $cancelling_user;
    public $cancellation_time;
    public $visitor_id;
    public $flag;

    // Joins
    public $accessEventLogs;
    public $site0;
    public $status0;
    public $submissions;
    public $visitor;

    /**
     * {@inheritdoc}
     */
    public function client(): VMSClient {
        return new VMSClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'api/v2/visit', // v2 is deliberate
        ];
    }

    public static function findById(int $id): static {
        $model = self::findOne(['id' => $id]);
        if ($model === null) {
            throw new NotFoundHttpException("Visit not found");
        }

        return $model;
    }

    public static function findByGuid(string $guid): static {
        $model = self::findOne(['visit' => $guid]);
        if ($model === null) {
            throw new NotFoundHttpException("Visit not found");
        }

        return $model;
    }
}
