<?php

namespace onespace\tools\activeApi\models\people;

use onespace\tools\activeApi\components\clients\PeopleClient;

/**
 * @property integer $id
 * @property string $guid
 * @property string $name
 * @property integer $type
 */
class Site extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $name;
    public $type;

    /**
     * {@inheritdoc}
     */
    public function client(): PeopleClient {
        return new PeopleClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/site',
        ];
    }
}
