<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $guid
 * @property string $site_id
 * @property string $property_id
 * @property string $name
 * @property integer $physical_perimeter
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class AccessPoint extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $site_id;
    public $property_id;
    public $name;
    public $physical_perimeter;

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/access-point',
        ];
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function attributeLabels() {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'id' => 'ID',
            'guid' => 'Guid',
            'site_id' => 'Site ID',
            'property_id' => 'Property ID',
            'name' => 'Name',
            'physical_perimeter' => 'Physical Perimeter',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    #[\Override]
    public function attributeHints() {
        return ArrayHelper::merge(parent::attributeHints(), [
            'id' => 'Primary Key',
            'guid' => 'GUID of this access_point - mapped from Property GUID',
            'site_id' => 'Link to the site for which this point belongs',
            'property_id' => 'GUID from the property',
            'name' => 'Name of the Access Point',
            'physical_perimeter' => 'Whether the point is on the physical perimeter of the site.',
        ]);
    }
}
