<?php

namespace onespace\tools\activeApi\components\clients;

use Yii;
use yii\httpclient\Request;
use yii\httpclient\Response;

class PropertyClient extends \onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient {
    public function __construct(
        public string $uri = '',
        public array $data = [],
    ) {
        // $this->init();
    }

    public function serverUrl(): string {
        return Yii::$app->params['serviceUrls']['property'];
    }

    public static function compose(string $uri, array $data = []): static {
        return new self($uri, $data);
    }

    public function getWithoutSend(): Request {
        $url = $this->serverUrl . $this->uri . ($this->data != null ? '?' . http_build_query($this->data) : '');
        return $this->client->get($url);
    }

    public function get(): Response {
        return $this->getWithoutSend()->send();
    }

    public function postWithoutSend(): Request {
        return $this->client->post($this->serverUrl . $this->uri, ['data' => $this->data]);
    }

    public function post(): Response {
        return $this->postWithoutSend()->send();
    }

    public function putWithoutSend(): Request {
        return $this->client->put($this->serverUrl . $this->uri, ['data' => $this->data]);
    }

    public function put(): Response {
        return $this->putWithoutSend()->send();
    }

    public function deleteWithoutSend(): Request {
        return $this->client->delete($this->serverUrl . $this->uri, ['data' => $this->data]);
    }

    public function deleteHttp(): Response {
        return $this->deleteWithoutSend()->send();
    }

    /**
     * Send multiple requests at once
     * @param Request[] $requests list of requests
     * @return Response[] list of responses. Keys correspond to keys of request list
     */
    public function batchSend(array $requests): array {
        return $this->client->batchSend($requests);
    }
}
