<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $owner_osid
 * @property string $site_id
 * @property string $body_part
 * @property string $manufacturer
 * @property string $payload
 * @property integer $status
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class UserBiometricStaging extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $owner_osid;
    public $site_id;
    public $body_part;
    public $manufacturer;
    public $payload;
    public $status;

    public const BODY_PART_FACE = 'face';

    public const STATUS_PENDING = 0;
    public const STATUS_DENIED = 2;

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/user-biometric-staging',
            // 'v2' => 'v2/user-biometric-staging',
        ];
    }
}
