<?php

use yii\db\Migration;

/**
 * Class m240723_064711_add_zoho_settings_table
 */
class m240723_064711_add_zoho_settings_table extends Migration {
    /**
     * {@inheritdoc}
     */
    public function safeUp() {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable(
            '{{%zoho_settings}}',
            [
                'id' => $this->primaryKey(),
                'setting_group' => $this->string(254)->comment("A meta key to group together certain sets of keys."),
                'setting_key' => $this->string(254)->notNull()->comment("The key identifier of the setting."),
                'setting_value' => $this->string(254)->comment("The setting value."),
            ],
            $tableOptions
        );

        $this->insert('{{%zoho_settings}}', [
            'setting_group' => 'oAuth',
            'setting_key' => 'accessToken',
            'setting_value' => null,
        ]);

        $this->insert('{{%zoho_settings}}', [
            'setting_group' => 'oAuth',
            'setting_key' => 'refreshToken',
            'setting_value' => null,
        ]);

        $this->insert('{{%zoho_settings}}', [
            'setting_group' => 'oAuthScope',
            'setting_key' => 'ZohoBooks.contacts.READ',
            'setting_value' => 1,
        ]);

        $this->insert('{{%zoho_settings}}', [
            'setting_group' => 'scopeAuthenticated',
            'setting_key' => 'authenticated',
            'setting_value' => 0,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown() {
        $this->dropTable('{{%zoho_settings}}');
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m240723_064711_add_zoho_settings_table cannot be reverted.\n";

        return false;
    }
    */
}
