<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $site_id
 * @property integer $biometric_settings
 * @property array $rollover_settings
 * @property string $timezone_offset
 * @property integer $pin_length
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class Site extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $site_id;
    public $biometric_settings;
    public $rollover_settings;
    public $timezone_offset;
    public $legacy_access_control_key;

    /**
     * {@inheritdoc}
     */
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/site',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['site_id', 'biometric_settings', 'legacy_access_control_key'], 'default', 'value' => null],
            [['timezone_offset'], 'default', 'value' => '2:00'],
            [['pin_length'], 'default', 'value' => 6],
            [['biometric_settings', 'pin_length'], 'integer'],
            [['rollover_settings'], 'required'],
            [['rollover_settings'], 'safe'],
            [['site_id', 'legacy_access_control_key'], 'string', 'max' => 45],
            [['timezone_offset'], 'string', 'max' => 10],
            [['site_id'], 'unique'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'id' => 'ID',
            'site_id' => 'Site ID',
            'biometric_settings' => 'Biometric Settings',
            'rollover_settings' => 'Rollover Settings',
            'timezone_offset' => 'Timezone Offset',
            'legacy_access_control_key' => 'Legacy Access Control Key',
            'pin_length' => 'Pin Length',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeHints() {
        return ArrayHelper::merge(parent::attributeHints(), [
            'site_id' => 'Site ID',
            'biometric_settings' => 'Biometric Settings',
            'rollover_settings' => 'A configuration for whether or not a rollover is enabled.',
            'timezone_offset' => 'The timezone offset of this specific site',
            'legacy_access_control_key' => 'Used for user_biometrics that were stored with the legacy access control key.',
            'pin_length' => 'The number of numbers in a pin on this site',
        ]);
    }
}
