<?php

namespace onespace\tools\activeApi\models\onedevice;

use onespace\tools\activeApi\components\clients\OneDeviceClient;
use yii\helpers\ArrayHelper;

/**
 * @property integer $id
 * @property string $platform
 * @property array $image
 * @property string $image_hash
 * @property integer $default_block_size
 * @property string $version
 * @property integer $status
 * @property string $date_added
 * @property string $date_updated
 * @property integer $validation_time
 * @property string $added_by
 *
 * @property \app\models\DfuDetails[] $dfuDetails
 */
class Firmware extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $platform;
    public $image;
    public $image_hash;
    public $default_block_size;
    public $version;
    public $status;
    public $date_added;
    public $date_updated;
    public $validation_time;
    public $added_by;

    /**
     * {@inheritdoc}
     */
    public function client(): OneDeviceClient {
        return new OneDeviceClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/firmware',
        ];
    }

    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['status'], 'default', 'value' => 0],
            [['platform', 'image_hash', 'default_block_size', 'version', 'date_added', 'date_updated', 'validation_time', 'added_by'], 'required'],
            [['date_added', 'date_updated'], 'safe'],
            [['default_block_size', 'status', 'validation_time'], 'integer'],
            [['platform', 'image_hash', 'version'], 'string', 'max' => 255],
            [['added_by'], 'string', 'max' => 36]
        ]);
    }

    public function attributeLabels() {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'id' => 'ID',
            'platform' => 'Platform',
            'image_hash' => 'Image Hash',
            'default_block_size' => 'Default Block Size',
            'version' => 'Version',
            'status' => 'Status',
            'date_added' => 'Date Added',
            'date_updated' => 'Date Updated',
            'validation_time' => 'Validation Time',
            'added_by' => 'Added By',
        ]);
    }

    public function attributeHints() {
        return ArrayHelper::merge(parent::attributeHints(), [
            'id' => 'Primary Key.',
            'platform' => 'The platform ID of this image',
            'image_hash' => 'SHA256 has of this image',
            'default_block_size' => 'The default block size for this image',
            'version' => 'The version id of this image',
            'status' => 'Enum of acceptance status of this firmware version',
            'date_added' => 'The date this firmware image was added',
            'date_updated' => 'The date this record was last updated',
            'validation_time' => 'The max duration when validating this image',
            'added_by' => 'OSID of the person adding this image',
        ]);
    }
}
