<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $guid
 * @property string $site_id
 * @property string $property_id
 * @property string $name
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class AccessPoint extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    public $id;
    public $guid;
    public $site_id;
    public $property_id;
    public $name;

    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    public function primaryKey(): string {
        return 'id';
    }

    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/access-point',
        ];
    }
}
