<?php

namespace onespace\tools\activeApi\helpers;

use onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient;

/**
 * Ensures the API Client class is set.
 */
trait ApiClientHelperTrait {
    /**
     * Property containing the client used by the API object.
     *
     * @var \onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient  $_client
     *
     * @access  private
     */

    private BaseOneSpaceClient $_client;

    /**
     * Sets the client. This should defined in every model.
     *
     * Something like:
     *
     * ```php
     * public function client(): BaseOneSpaceClient {
     *  return new MyServiceOneSpaceClientExtendingBaseOneSpaceClient();
     * }
     * ```
     *
     * @return   \onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient
     *
     * @access  public
     */
    abstract public function client(): BaseOneSpaceClient;

    /**
     * Sets the client from the `client()` method.
     *
     * @access  public
     */
    public function setClient(): void {
        $this->_client = $this->client();
    }

    /**
     * Returns the client. If the client isn't set, it also sets it.
     *
     * @return   \onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient
     *
     * @access  public
     */
    public function getClient(): BaseOneSpaceClient {
        if (!isset($this->client)) {
            $this->setClient();
        }
        return $this->_client;
    }
}
