<?php

namespace onespace\tools\activeApi\models\oneaccess;

use onespace\tools\activeApi\components\clients\OneAccessClient;
use yii\helpers\ArrayHelper;

/**
 * This class is intended to be extended from within the child service,
 * though it shouldn't need to be if you just need a basic interface
 * with the method / endpoint without any extra methods.
 *
 * @property integer $id
 * @property string $site_id
 * @property integer $biometric_settings
 * @property array $rollover_settings
 *
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class Site extends \onespace\tools\activeApi\models\BaseActiveApiModel {
    /**
     * {@inheritdoc}
     */
    public function client(): OneAccessClient {
        return new OneAccessClient();
    }

    /**
     * {@inheritdoc}
     */
    public function primaryKey(): string {
        return 'id';
    }

    /**
     * {@inheritdoc}
     */
    public function baseEndpoints(): array {
        return [
            'v1' => 'v1/site',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules() {
        $parentRules = parent::rules();
        return ArrayHelper::merge($parentRules, [
            [['site_id', 'biometric_settings'], 'default', 'value' => null],
            [['biometric_settings'], 'integer'],
            [['rollover_settings'], 'required'],
            [['rollover_settings'], 'safe'],
            [['site_id'], 'string', 'max' => 45],
            [['site_id'], 'unique'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'id' => 'ID',
            'site_id' => 'Site ID',
            'biometric_settings' => 'Biometric Settings',
            'rollover_settings' => 'Rollover Settings',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function attributeHints() {
        return ArrayHelper::merge(parent::attributeHints(), [
            'site_id' => 'Site ID',
            'biometric_settings' => 'Biometric Settings',
            'rollover_settings' => 'A configuration for whether or not a rollover is enabled.',
        ]);
    }
}
