<?php

namespace onespace\tools\activeApi\components\clients;

use onespace\tools\activeApi\components\clients\base\BaseOneSpaceClient;
use Yii;

/**
 * The client to connect to the OneAccess Microservice
 *
 * Extend from here to add functionality.
 *
 * Add the following to `config/params.php`:
 *
 * ```php
 * 'serviceUrls' => [
 *  ...
 *  'oneAccess' => getenv('SERVICE_URL_ONEACCESS') ?: 'https://dev.1access.1s.co.za/',
 *  ...
 * ],
 * ```
 */

class OneAccessClient extends BaseOneSpaceClient {
    public function serverUrl(): string {
        return Yii::$app->params['serviceUrls']['oneAccess'];
    }

    public function linkAccessRightAccessGateway(int $rightId, int $gatewayId): bool {
        $url = $this->serverUrl() . 'v2/access-right/access-point-add';
        Yii::info($url, __METHOD__);

        $request = $this->getClient()->post($url, [
            'rightId' => $rightId,
            'gatewayId' => $gatewayId,
        ]);

        $this->setLastRequest($request);
        $response = $request->send();
        if ($response->isOk) {
            return $response->data['success'];
        }
        return false;
    }
}
